package gov.va.med.mhv.journal.service;

import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.springframework.stereotype.Service;

import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.journal.dto.ActivityDetailDTO;
import gov.va.med.mhv.journal.dto.ActivityJournalDTO;
import gov.va.med.mhv.journal.dto.FoodJournalDTO;
import gov.va.med.mhv.journal.dto.MealItemDTO;

@Path("/")
@Service
public interface JournalWebService {

	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("journals/{userProfileId}")
	public List<FoodJournalDTO> getFoodJournalsForUser(@PathParam("userProfileId") Long userProfileId) throws MHVException;

	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("journals/dashboard/{userProfileId}")
	public List<FoodJournalDTO> getFoodJournalsForDashBoard(@PathParam("userProfileId") Long userProfileId) throws MHVException;

	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("journal/{foodJournalId}")
	public FoodJournalDTO getFoodJournalById(@PathParam("foodJournalId") Long foodJournalId) throws MHVException;

	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("activityjournals/{userProfileId}")	
	public List<ActivityJournalDTO> findActivityJournalsForUser(@PathParam("userProfileId") Long userProfileId) throws MHVException;
	
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("activityjournal/{activityJournalId}")	
	public ActivityJournalDTO findActivityJournalById(@PathParam("activityJournalId") Long activityJournalId) throws MHVException;
	
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("activityjournal/dashboard/{userProfileId}")
	public List<ActivityJournalDTO> getActivityJournalsForDashBoard(@PathParam("userProfileId") Long userProfileId) throws MHVException;
	
	@POST
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	@Path("foodjournal")
	public FoodJournalDTO addFoodJournal(FoodJournalDTO foodJournalDTO) throws MHVException;
	
	@POST
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	@Path("activityjournal")
	public ActivityJournalDTO addActivityJournal(ActivityJournalDTO activityJournalDTO) throws MHVException;
	
	@DELETE
	@Produces(MediaType.APPLICATION_JSON)
	@Path("foodjournal/{foodJournalId}")
	public void deleteFoodJournalById(@PathParam("foodJournalId") Long foodJournalId) throws MHVException;

	@POST
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	@Path("meal")
	public MealItemDTO addMealItem(MealItemDTO mealItemDTO) throws MHVException;
	
	@POST
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	@Path("activitydetail")
	public ActivityDetailDTO addActivityDetails(ActivityDetailDTO activityDetailDTO) throws MHVException;
	
	@DELETE
	@Produces(MediaType.APPLICATION_JSON)
	@Path("meal/{mealItemId}")
	public void deleteMealItemById(@PathParam("mealItemId") Long mealItemId) throws MHVException;
	
	@POST
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	@Path("meal/{mealItemId}")
	public MealItemDTO getMealItemById(@PathParam("mealItemId") Long mealItemId) throws MHVException;
	
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("activitydetail/{activityDetailId}")
	public ActivityDetailDTO getActivityDetailById(@PathParam("activityDetailId") Long activityDetailId) throws MHVException;
	
	@DELETE
	@Produces(MediaType.APPLICATION_JSON)
	@Path("activityjournal/{activityJournalId}")
	public void deleteActivityJournalById(@PathParam("activityJournalId") Long activityJournalId) throws MHVException;
	
	@DELETE
	@Produces(MediaType.APPLICATION_JSON)
	@Path("activitydetail/{activityDetailId}")
	public void deleteActivityDetailById(@PathParam("activityDetailId") Long activityDetailId) throws MHVException;
	
}
